﻿//////////////////////////////////////////////
// Material.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Shader ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

#include "MaterialType.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT Material : public nkExport::Exportable
	{
		public :

			// Constructor, destructor
			Material (MATERIAL_TYPE type) noexcept ;
			virtual ~Material () ;

			// Getters
			nkMemory::StringView getName () const ;
			nkGraphics::Shader* getShader () const ;
			MATERIAL_TYPE getType () const ;

			// Setters
			void setName (nkMemory::StringView value) ;

			// Load
			virtual bool load () = 0 ;
			virtual void unload () = 0 ;

			// Import / export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		protected :

			// Attributes
			// Name for identification
			nkMemory::String _name ;

			// Final shader that will be held by the material, populated by child class
			nkMemory::UniquePtr<nkGraphics::Shader> _shader ;

			// Type
			MATERIAL_TYPE _type ;
	} ;
}